/*
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * This filter first stores print data to a file and then sends the
 * file data to the named pipe. This gets around the 4K burst limitation
 * of the named pipe on Ultrix 4.3. 
 */ 

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <netdb.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>

#include <time.h>

#include <ctype.h>      /* crosscode headers */
#include "recognize.h"     /* defines constants and types used by IQ   */

#define SIZEOF_XMIT_BUF 1024

char	xmit_buf[SIZEOF_XMIT_BUF];
char	upper_buf[SIZEOF_XMIT_BUF];

void	sig_handler() ;
char	*host_arg;
int	port_num;
char	*suppress;
char	*user;
char	*req;
char	*job;
char	printer[128];

char	banner[128];
struct	sockaddr_in  saddr;

int	print_fd ;
int     read_size, write_size;

void	sigpipe_handler() ;
void	sighup_handler() ;

main( argc, argv )
int	argc;
char	*argv[];
{
int	chars=0;
int	type=0,initial=1;
	
	
	signal( SIGPIPE, sigpipe_handler ) ;
	signal( SIGHUP, sighup_handler ) ;
	signal( SIGINT, sighup_handler ) ;

	host_arg = argv[1];
        port_num = atoi(argv[2]);
	suppress = argv[3];

	get_host_data() ;

	open_printer() ;

	while ((chars = getbuf()) > 0)
	{
		if (initial)
		{
			make_uppercase(xmit_buf, chars, upper_buf);

			type = recognize(upper_buf);

			if (suppress && strcmp(suppress,"yes"))
			{
	    			do_banner(argv, type);
			}

			initial = 0;
		}

		putbuf(chars, type);
	}

	close( print_fd ) ;
	exit(0);
}



int getbuf()

{

int	c, count=0;

	while ((count < SIZEOF_XMIT_BUF) && (c = getchar()) != EOF) 
        {
		xmit_buf[count++] = c;
	}

/*
	if (count && (c == EOF))
		xmit_buf[count++] = 4;
*/

	return(count);

}

int putbuf(chars, type)
int	chars;
int	type;

{
int	i=0, j, col=0;

	write_size = send( print_fd, xmit_buf, chars, 0 ) ;

}


int open_printer() {
extern int errno ;
struct linger linger;



	while( 1 ) {

		if ( (print_fd = socket(AF_INET, SOCK_STREAM, 0)) <0 ) {
			perror( "can't get socket" );
			exit(-1);
		}

		if ( connect( print_fd,
			     (struct sockaddr *) &saddr, sizeof(saddr) ) < 0) {

			close( print_fd ) ;
			sleep( 5 ) ;
		}
		else {
			break ;
		}
	}

	/* At this point we are connected. AT&T System V needs linger turned
	   on to finish transmitting on close */
	linger.l_onoff = 1;
	linger.l_linger = 10;

	setsockopt(print_fd, SOL_SOCKET, SO_LINGER, (char *)&linger, 
			sizeof(struct linger)); 

}

get_host_data() {

struct hostent		 *host_ptr;
int                      i;
char                     *src, *dest;

	if ( ( host_ptr = gethostbyname( host_arg ) ) == NULL ) {
;
	}

	/* bzero( (char *) &saddr, sizeof(saddr));                 */
        src = (char *)&saddr;
        for (i=0; i < sizeof(saddr); i++)
           *src++ = 0;

	saddr.sin_family	= AF_INET;
	saddr.sin_port		= htons(port_num);

	/*  bcopy( host_ptr->h_addr, (char *)&saddr.sin_addr, 
                   host_ptr->h_length ) ;                          */
        src = (char *)host_ptr->h_addr_list[0];
        dest = (char *)&saddr.sin_addr;

        for (i=0; i < host_ptr->h_length; i++)
           *dest++ = *src++;
}

/*
 * Name:        is_pcl
 *
 * Function:    Returns a non-zero value if the current job is a PCL job.
 */

void sigpipe_handler() {

;
}

void sighup_handler() {

;
}


dump(buf)
char *buf;
{
   send(print_fd, buf, strlen(buf), 0);
}


do_banner(arg_list, type)
char *arg_list[];
int   type;
{
	FILE *test;
	int   check;
	int i, len;
	char old_req[128], tmpfile[128];
	int read_size;
	char ban_buf[1024];
	time_t t_buf;

	user = arg_list[4];
	req = arg_list[5];
	job = arg_list[6];

	if (!user || !req || !job)
		return;

	for (i = 0; i < strlen(req); i++)
	  {
		if (req[i] == '-')
		    break;
	  }

	strncpy(printer, req, i);
  	sprintf(tmpfile,"/usr/dpi/printers/%s", printer);
	if ((check = open(tmpfile, O_RDONLY)) < 0)
	  {
		mkdir("/usr/dpi/printers", 0666);
		chmod ("/usr/dpi/printers", 0666);

		if ((check = open(tmpfile, O_CREAT | O_WRONLY)) < 0)
		    return;

		fchmod (check, 0666);
		write(check,req, strlen(req));
	  }
	else
	  {
                read_size = read(check,old_req, sizeof(old_req));

                if (!strncmp(req, old_req, read_size))
		   return;
		else
		  {
			close(check);
			if ((check = open(tmpfile, O_TRUNC | O_WRONLY)) < 0)
		    		return;

			write(check,req, strlen(req));
		  }
	  }

	close(check);

	if (type == POSTSCRIPT_JOB)
		pspreamble();

  	sprintf(banner,"\r\n\r\n*************************************************\r\n");
	dump(banner);
  	sprintf(banner,"*************************************************\r\n");
	dump(banner);
  	sprintf(banner,"*************************************************\r\n\r\n\r\n\r\n");
	dump(banner);

  	sprintf(banner,"banner %s", user);
        test = popen(banner,"r");

        while ((fgets(ban_buf,"%s", test)) != NULL)
            {
		len = strlen(ban_buf);
		ban_buf[len-1] = '\r';
		ban_buf[len] = '\n';
                write (print_fd, ban_buf, len+1);
            }

        pclose(test);

  	sprintf(banner,"\r\n\r\n\r\n***** User name : %s\r\n", user);
	dump(banner);

	sprintf(banner,"\r\n***** Request   : %s\r\n", req);
	dump(banner);

  	sprintf(banner,"\r\n***** Jobs      : %s", job);
	dump(banner);
	i = 7;

	while (job)
	  {
		job = arg_list[i];
		i++;

		if (job)
		  {
  			sprintf(banner," %s ", job);
			dump(banner);
		  }
	  }

	sprintf(banner,"\r\n");
	dump(banner);

	time(&t_buf);

	if (type == POSTSCRIPT_JOB)
		sprintf(banner,"\r\n***** Date      : %s\r\n\f%c", ctime(&t_buf), 4 );
	else
		sprintf(banner,"\r\n***** Date      : %s\r\n\f", ctime(&t_buf));
	dump(banner);

}


pspreamble()
 
{
        sprintf (banner, "/printloop{{currentfile cvlit =string readline not {exit} if\n");
        dump(banner);
 
        sprintf (banner, "show currentpoint exch pop\n");
        dump(banner);
 
        sprintf (banner, "10.5 sub dup 36 le {pop showpage 72 730 moveto}\n");
        dump(banner);
 
        sprintf (banner, "{72 exch moveto} ifelse} loop showpage}\n");
        dump(banner);
 
        sprintf (banner, "bind def /Courier findfont 11 scalefont setfont\n");
        dump(banner);
 
        sprintf (banner, "72 730 moveto printloop\n");
        dump(banner);
}
